﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Management

Public Class MainForm


    '此子例程使用 WMI 中的 BIOS 信息填充输出文本框
    Private Sub btnBios_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBios.Click
        '显示如何使用 SelectQuery 对象替代 SELECT 
        '语句。
        Dim query As New SelectQuery("Win32_bios")

        'ManagementObjectSearcher 根据查询检索 WMI 对象
        '的集合。
        Dim search As New ManagementObjectSearcher(query)

        '显示 Win32_bios 的每个项
        Dim info As ManagementObject
        For Each info In search.Get()
            txtOutput.Text = "Bios version: " & info("version").ToString() & vbCrLf
        Next
    End Sub

    '此子例程使用 WMI 中的计算机系统信息填充输出
    '文本框
    Private Sub btnComputerSystem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnComputerSystem.Click
        'ManagementObjectSearcher 根据查询检索 WMI 对象
        '的集合。本例使用字符串而不是 SelectQuery 对象。
        Dim search As New ManagementObjectSearcher("SELECT * FROM Win32_ComputerSystem")

        '显示 Win32_ComputerSystem 的每个项
        Dim info As ManagementObject
        For Each info In search.Get()
            txtOutput.Text = "Manufacturer: " & info("manufacturer").ToString() & vbCrLf
            txtOutput.Text &= "Model: " & info("model").ToString() & vbCrLf
            txtOutput.Text &= "System Type: " & info("systemtype").ToString() & vbCrLf
            txtOutput.Text &= "Total Physical Memory: " & _
                info("totalphysicalmemory").ToString() & vbCrLf
        Next
    End Sub

    '此子例程使用所有 WMI 类来填充列表框。
    Private Sub btnClassEnum_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClassEnum.Click
        '清除列表框
        lstWMIClasses.Items.Clear()

        'ManagementClass 的默认构造函数将返回 cim 根。
        Dim root As New ManagementClass()

        '如果选中“Subclasses”（子类）复选框，我们将获得所有子类，还将获得顶
        '层类。
        Dim options As New EnumerationOptions()
        options.EnumerateDeep = chkIncludeSubclasses.Checked

        '将枚举中的每个 WMI 类添加到列表框。
        Dim info As ManagementObject
        For Each info In root.GetSubclasses(options)
            lstWMIClasses.Items.Add(info("__Class"))
        Next
    End Sub

    '此子例程使用 WMI 中的操作系统信息填充输出
    '文本框
    Private Sub btnOperatingSytem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOperatingSytem.Click
        'ManagementObjectSearcher 根据查询检索 WMI 对象
        '的集合。本例使用字符串而不是 SelectQuery 对象。
        Dim search As New ManagementObjectSearcher("SELECT * FROM Win32_OperatingSystem")

        '显示 Win32_OperatingSystem 的每个项
        Dim info As ManagementObject
        For Each info In search.Get()
            txtOutput.Text = "Name: " & info("name").ToString() & vbCrLf
            txtOutput.Text &= "Version: " & info("version").ToString() & vbCrLf
            txtOutput.Text &= "Manufacturer: " & info("manufacturer").ToString() & vbCrLf
            txtOutput.Text &= "Computer name: " & info("csname").ToString() & vbCrLf
            txtOutput.Text &= "Windows Directory: " & _
                info("windowsdirectory").ToString() & vbCrLf
        Next
    End Sub

    '此子例程使用 WMI 中的处理器信息填充输出
    '文本框
    Private Sub btnProcessor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcessor.Click
        '显示如何使用 SelectQuery 对象替代 SELECT
        '语句。
        Dim query As New SelectQuery("Win32_processor")

        'ManagementObjectSearcher 根据查询检索 WMI 对象
        '的集合。
        Dim search As New ManagementObjectSearcher(query)

        '显示 Win32_processor 的每个项
        Dim info As ManagementObject
        For Each info In search.Get()
            txtOutput.Text = "Processor: " & info("caption").ToString() & vbCrLf
        Next
    End Sub

    '此子例程使用 WMI 中的时区信息填充输出文本框
    Private Sub btnTimeZone_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTimeZone.Click
        '显示如何使用 SelectQuery 对象替代 SELECT
        '语句。
        Dim query As New SelectQuery("Win32_timezone")

        'ManagementObjectSearcher 根据查询检索 WMI 对象
        '的集合。
        Dim search As New ManagementObjectSearcher(query)

        '显示 Win32_timezone 的每个项
        Dim info As ManagementObject
        For Each info In search.Get()
            txtOutput.Text = "Time zone: " & info("caption").ToString() & vbCrLf
        Next
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
